/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.gridder;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.gridder.NcGridder;
import java.awt.Dimension;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NcGridder2D
extends NcGridder {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected int gridWidth_;
    protected int gridHeight_;
    protected double lBound_;
    protected double rBound_;
    protected double tBound_;
    protected double bBound_;
    protected double[] colXX_;
    protected double[] rowYY_;

    public NcGridder2D() {
        this(100, 50);
    }

    public NcGridder2D(Dimension size) {
        this(size.width, size.height);
    }

    public NcGridder2D(int w, int h) {
        this.setSize(w, h);
        this.setBounds(0.0, 0.0, 1.0, 1.0);
    }

    public void setSize(int w, int h) {
        this.gridWidth_ = w;
        this.gridHeight_ = h;
    }

    public boolean setBounds(double[] bounds) {
        return this.setBounds(bounds[0], bounds[1], bounds[2], bounds[3]);
    }

    public boolean setBounds(double l, double t, double r, double b) {
        LOGGER.trace("l {}, t {}, r {}, b {}", l, t, r, b);
        this.lBound_ = l;
        this.tBound_ = t;
        this.rBound_ = r;
        this.bBound_ = b;
        return true;
    }

    public abstract void regridNoInterpolate(NcArray var1, double[] var2);

    public abstract void regridInterpolate(NcArray var1, double[] var2);
}

