/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array.projected;

import gov.nasa.giss.data.nc.NcAxisType;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcLLAltGridding;
import gov.nasa.giss.data.nc.NcLLAltGriddingVarType;
import gov.nasa.giss.data.nc.NcUnitUtils;
import gov.nasa.giss.data.nc.NcVarType;
import gov.nasa.giss.data.nc.NcVarUtils;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArrayLonLatProjected;
import gov.nasa.giss.data.nc.array.NcLonLatProjection;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;
import java.util.List;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.VariableDS;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.projection.TransverseMercator;
import ucar.unidata.geoloc.projection.proj4.TransverseMercatorProjection;
import ucar.units.Converter;
import ucar.units.SI;
import ucar.units.ScaledUnit;
import ucar.units.Unit;

public class NcArrayLonLatTransverseMercator
extends NcArrayLonLatProjected {
    private Projection njProj_;
    private Converter toProjUnits_;
    private Converter fromProjUnits_;

    public NcArrayLonLatTransverseMercator(NcVariable ncvar) throws NcException {
        super(ncvar, NcLonLatProjection.TRANSVERSE_MERCATOR);
        this.initMe();
    }

    private void initMe() {
        NcVarType vtype = this.ncvar_.getVarType();
        if (!(vtype instanceof NcLLAltGriddingVarType)) {
            throw new NcException("Variable is not on a projected grid.");
        }
        if (!((NcLLAltGriddingVarType)vtype).isGrid(NcLLAltGridding.TRANSVERSE_MERCATOR)) {
            throw new NcException("Variable is not projected type transverse Mercator.");
        }
        this.initUnidataProj();
    }

    private void initUnidataProj() {
        VariableDS njvarDS = (VariableDS)this.ncvar_.getObject();
        List csList = njvarDS.getCoordinateSystems();
        if (csList.isEmpty()) {
            throw new NcException("No coordinate system(s) reported.");
        }
        CoordinateSystem cs = (CoordinateSystem)csList.get(0);
        ProjectionImpl pj = cs.getProjection();
        if (pj == null) {
            throw new NcException("CS returned null projection handler.");
        }
        if (!(pj instanceof TransverseMercator) && !(pj instanceof TransverseMercatorProjection)) {
            throw new NcException("CS returned wrong proj - " + pj.getClass());
        }
        this.njProj_ = pj;
        String xUnits = NcVarUtils.getCoordinateAxisOfType(this.ncvar_, NcAxisType.GEOX).getUnitsString();
        try {
            ScaledUnit projUnit = new ScaledUnit(1000.0, SI.METER);
            Unit eastUnit = NcUnitUtils.parse(xUnits);
            this.toProjUnits_ = eastUnit.getConverterTo(projUnit);
            this.fromProjUnits_ = projUnit.getConverterTo(eastUnit);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Point2D.Double transformLL2XY(double lon, double lat) {
        Point2D.Double xy = NcArrayLonLatTransverseMercator.transformNjLL2XY(this.njProj_, lon, lat);
        if (xy == null) {
            return null;
        }
        if (this.fromProjUnits_ != null) {
            xy.x = this.fromProjUnits_.convert(xy.x);
            xy.y = this.fromProjUnits_.convert(xy.y);
        }
        return xy;
    }

    @Override
    public PointLL transformXY2LL(double x, double y) {
        double xx = this.toProjUnits_ == null ? x : this.toProjUnits_.convert(x);
        double yy = this.toProjUnits_ == null ? y : this.toProjUnits_.convert(y);
        return NcArrayLonLatTransverseMercator.transformNjXY2LL(this.njProj_, xx, yy);
    }
}

