/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array;

import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.NcAxisType;
import gov.nasa.giss.data.nc.NcDataset;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcStringUtils;
import gov.nasa.giss.data.nc.NcTimeAxis;
import gov.nasa.giss.data.nc.NcVarUtils;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArray2D;
import gov.nasa.giss.data.nc.gridder.NcGridder;
import gov.nasa.giss.data.nc.gridder.NcGridderTimeLat;
import gov.nasa.giss.text.PrintfFormat;
import java.util.Objects;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.VariableDS;

public class NcArrayTimeLat
extends NcArray2D {
    public NcArrayTimeLat(NcVariable ncvar) throws NcException {
        super(ncvar);
        this.setAxes();
        this.measureAxes();
    }

    @Override
    protected void setAxes() {
        VariableDS cv;
        NcDataset ncd = this.getDataset();
        CoordinateAxis x = NcVarUtils.getCoordinateAxisOfType(this.ncvar_, NcAxisType.TIME);
        CoordinateAxis y = NcVarUtils.getCoordinateAxisOfType(this.ncvar_, NcAxisType.LAT);
        if (x == null) {
            cv = NcVarUtils.getCoordinateVariable(this.ncvar_, NcAxisType.TIME);
            if (cv != null) {
                this.xAxis_ = new NcTimeAxis(ncd, cv);
                this.xDimNum_ = this.findDimensionIndex(cv);
            }
        } else {
            this.xAxis_ = new NcTimeAxis(ncd, x);
            this.xDimNum_ = this.findDimensionIndex(x);
        }
        if (y == null) {
            cv = NcVarUtils.getCoordinateVariable(this.ncvar_, NcAxisType.LAT);
            if (cv != null) {
                this.yAxis_ = new NcAxis(NcAxisType.LAT, ncd, cv);
                this.yDimNum_ = this.findDimensionIndex(cv);
            }
        } else {
            this.yAxis_ = new NcAxis(NcAxisType.LAT, ncd, y);
            this.yDimNum_ = this.findDimensionIndex(y);
        }
        if (this.xAxis_ == null) {
            throw new NcException("Got null retrieving TIME coordinate axis");
        }
        if (this.yAxis_ == null) {
            throw new NcException("Got null retrieving LAT coordinate axis");
        }
        if (this.xDimNum_ == -1) {
            throw new NcException("Unable to determine dim index for TIME axis");
        }
        if (this.yDimNum_ == -1) {
            throw new NcException("Unable to determine dim index for LAT axis");
        }
        CoordinateAxis a = NcVarUtils.getCoordinateAxisOfType(this.ncvar_, NcAxisType.LON);
        if (a != null) {
            this.setAveDimIndex(this.findDimensionIndex(a));
        }
    }

    @Override
    public NcGridder getGridder() {
        return new NcGridderTimeLat();
    }

    @Override
    public void describeCell(StringBuilder sb, PrintfFormat valFormat, int ... index) {
        Objects.requireNonNull(index, "Cell index cannot be null.");
        int col = index[0];
        int row = index[1];
        if (row < 0 || col < 0) {
            sb.append("Pt apparently outside data bounds");
            return;
        }
        double time = this.xAxis_.valueAt(col);
        double lat = this.yAxis_.valueAt(row);
        sb.append("Cell [").append(col + 1).append(", ").append(row + 1).append("] at [").append(PrintfFormat.PFORMAT_7G.sprintfx(time)).append(", ").append(NcStringUtils.formatLatitude(lat)).append("], value = ");
        double value = this.valueAt(col, row);
        sb.append(valFormat.sprintfx(value));
        if (Double.isNaN(value)) {
            return;
        }
        String unitsStr = this.getUnitsString();
        if (unitsStr != null && !unitsStr.isEmpty() && !unitsStr.equals("1")) {
            sb.append(' ').append(unitsStr);
        }
    }
}

