/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array;

import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.NcAxisType;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcStringUtils;
import gov.nasa.giss.data.nc.NcUnitUtils;
import gov.nasa.giss.data.nc.NcVarUtils;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.array.NcArray2D;
import gov.nasa.giss.data.nc.array.NcArrayLonLat;
import gov.nasa.giss.data.nc.array.NcLonLatProjection;
import gov.nasa.giss.data.nc.gridder.NcGridder;
import gov.nasa.giss.data.nc.gridder.NcGridderLonLatProjected;
import gov.nasa.giss.map.LonLatEdges;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.math.PointLL;
import gov.nasa.giss.text.PrintfFormat;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.VariableDS;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.units.Unit;

public abstract class NcArrayLonLatProjected
extends NcArray2D
implements NcArrayLonLat {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String MAP_VAR_NOT_FOUND_STR = "Grid mapping variable was not found";
    public static final String VAR_HAS_NO_MAP_NAME_STR = "Grid mapping variable has no mapping name";
    protected static final double PI = Math.PI;
    protected static final double PI_OVER_2 = 1.5707963267948966;
    private static final double DEFAULT_RADIUS = 6371.229;
    private final NcLonLatProjection projTyoe_;
    protected VariableDS mappingVarDS_;
    protected String mappingName_;
    protected double radius_ = 6371.229;
    protected double semimajor_ = Double.NaN;
    protected double semiminor_ = Double.NaN;
    protected double invFlat_ = Double.NaN;
    protected double eccen_ = Double.NaN;
    protected double eccen2_ = Double.NaN;
    protected double oneOverR_ = 1.0 / this.radius_;
    protected double lambdaC_;
    protected double phiC_;
    protected double falseEasting_;
    protected double falseNorthing_;
    protected double lBound_;
    protected double tBound_;
    protected double rBound_;
    protected double bBound_;

    public NcArrayLonLatProjected(NcVariable ncvar, NcLonLatProjection ptype) throws NcException {
        super(ncvar);
        LOGGER.trace("");
        this.projTyoe_ = ptype;
        this.setAxes();
        this.measureAxes();
        double[][] xBounds = this.getXAxis().getBounds();
        double[][] yBounds = this.getYAxis().getBounds();
        this.lBound_ = xBounds[0][0];
        this.tBound_ = yBounds[0][0];
        this.rBound_ = xBounds[xBounds.length - 1][1];
        this.bBound_ = yBounds[yBounds.length - 1][1];
    }

    public NcLonLatProjection getProjection() {
        return this.projTyoe_;
    }

    protected String getGridMappingName() {
        this.mappingVarDS_ = NcVarUtils.findGridMappingVariable(this.dataset_, this.njvarDS_);
        LOGGER.trace("Found mapping var {}", (Object)(this.mappingVarDS_ != null ? 1 : 0));
        if (this.mappingVarDS_ == null) {
            throw new NcException(MAP_VAR_NOT_FOUND_STR);
        }
        this.mappingName_ = NcVarUtils.getGridMappingName(this.mappingVarDS_);
        LOGGER.trace("Mapping name {}", (Object)this.mappingName_);
        if (this.mappingName_ == null) {
            throw new NcException(VAR_HAS_NO_MAP_NAME_STR);
        }
        return this.mappingName_;
    }

    protected void initCenter() {
        LOGGER.trace("");
        Attribute lonA = this.mappingVarDS_.findAttribute("longitude_of_projection_origin");
        Attribute latA = this.mappingVarDS_.findAttribute("latitude_of_projection_origin");
        if (lonA == null) {
            lonA = this.mappingVarDS_.findAttribute("straight_vertical_longitude_from_pole");
        }
        if (lonA == null) {
            lonA = this.mappingVarDS_.findAttribute("longitude_of_central_meridian");
        }
        if (lonA != null) {
            this.lambdaC_ = MapUtils.normalizeMP180(lonA.getNumericValue().doubleValue());
        }
        if (latA != null) {
            this.phiC_ = latA.getNumericValue().doubleValue();
        }
        LOGGER.trace("lambdaC {}, phiC {}", (Object)this.lambdaC_, (Object)this.phiC_);
    }

    protected void initRadiusEastingAndNorthing() {
        double d;
        double d2;
        Attribute eastingA = this.mappingVarDS_.findAttribute("false_easting");
        Attribute northingA = this.mappingVarDS_.findAttribute("false_northing");
        if (eastingA != null && !Double.isNaN(d2 = eastingA.getNumericValue().doubleValue())) {
            this.falseEasting_ = d2;
        }
        if (northingA != null && !Double.isNaN(d2 = northingA.getNumericValue().doubleValue())) {
            this.falseNorthing_ = d2;
        }
        LOGGER.trace("easting {}, northing {}", (Object)this.falseEasting_, (Object)this.falseNorthing_);
        Attribute radiusA = this.mappingVarDS_.findAttribute("earth_radius");
        Attribute semimajorA = this.mappingVarDS_.findAttribute("semi_major_axis");
        Attribute semiminorA = this.mappingVarDS_.findAttribute("semi_minor_axis");
        Attribute invFlattenA = this.mappingVarDS_.findAttribute("inverse_flattening");
        if (semimajorA == null) {
            semimajorA = this.mappingVarDS_.findAttribute("semi_major_axis");
        }
        if (semimajorA == null) {
            semimajorA = this.mappingVarDS_.findAttribute("earth_semi_major_axis");
        }
        if (semiminorA == null) {
            semiminorA = this.mappingVarDS_.findAttribute("semi_minor_axis");
        }
        if (semiminorA == null) {
            semiminorA = this.mappingVarDS_.findAttribute("earth_semi_minor_axis");
        }
        if (invFlattenA == null) {
            invFlattenA = this.mappingVarDS_.findAttribute("earth_inverse_flattening");
        }
        if (radiusA != null) {
            LOGGER.trace("Found single-valued earth_radius.");
            d = radiusA.getNumericValue().doubleValue();
            if (!Double.isNaN(d)) {
                this.radius_ = d;
            }
        } else if (semimajorA == null) {
            LOGGER.trace("No radius or semi-major axis defined. Using default sphere radius.");
            this.radius_ = 6371.229;
        } else if (semiminorA == null && invFlattenA == null) {
            LOGGER.trace("Semi-major axis found, but no semi-minor or flattening.");
            LOGGER.trace("Using semi-major axis as sphere radius.");
            d = semimajorA.getNumericValue().doubleValue();
            if (!Double.isNaN(d)) {
                this.radius_ = d;
            }
        } else {
            double smajor = semimajorA.getNumericValue().doubleValue();
            double sminor = semiminorA != null ? semiminorA.getNumericValue().doubleValue() : Double.NaN;
            double invf = invFlattenA != null ? invFlattenA.getNumericValue().doubleValue() : Double.NaN;
            double fflat = 0.0;
            if (Double.isNaN(sminor)) {
                LOGGER.trace("Calculating semi-minor axis from semi-major axis and from flattening.");
                fflat = 1.0 / invf;
                sminor = smajor * (1.0 - fflat);
            } else if (Double.isNaN(invf)) {
                LOGGER.trace("Calculating inverse flattening from semi-major and semi-minor axes.");
                if (smajor == sminor) {
                    LOGGER.trace("Semi-major and semi-minor axes are same value. Flattening is 0.");
                    fflat = 0.0;
                    invf = 0.0;
                } else {
                    fflat = (smajor - sminor) / smajor;
                    invf = 1.0 / invf;
                }
            } else {
                fflat = 1.0 / invf;
                double xsminor = smajor * (1.0 - fflat);
                if (Math.abs(sminor - xsminor) > 1.0E-7) {
                    LOGGER.trace("Found semi-major and semi-minor axes and flattening.");
                    LOGGER.trace("But values are not consistent.");
                    LOGGER.trace("Ignoring the semi-minor axis value.");
                }
                sminor = xsminor;
            }
            double ee = fflat == 0.0 ? 0.0 : Math.sqrt((smajor * smajor - sminor * sminor) / (smajor * smajor));
            LOGGER.trace("smajor {}", (Object)smajor);
            LOGGER.trace("sminor {}", (Object)sminor);
            LOGGER.trace("fflat  {}", (Object)fflat);
            LOGGER.trace("1./f {}", (Object)invf);
            LOGGER.trace("e    {}", (Object)ee);
            this.semimajor_ = smajor;
            this.semiminor_ = sminor;
            this.invFlat_ = invf;
            this.eccen_ = ee;
            this.eccen2_ = ee * ee;
            this.radius_ = (2.0 * this.semimajor_ + this.semiminor_) / 3.0;
        }
        String radiusUnits = this.radius_ < 10000.0 ? "km" : "m";
        LOGGER.trace("radius {} {}", (Object)this.radius_, (Object)radiusUnits);
        String xUnits = this.xAxis_ != null ? this.xAxis_.getUnitsString() : null;
        LOGGER.trace("xAxis {}", (Object)this.xAxis_);
        if (xUnits == null || xUnits.isEmpty()) {
            LOGGER.trace("False easting variable has null/no units!");
            LOGGER.trace("I will assume radius units are same as easting units.");
        } else {
            try {
                Unit drUnit = NcUnitUtils.parse(radiusUnits);
                Unit feUnit = NcUnitUtils.parse(xUnits);
                LOGGER.trace("r units {}, fe units {}", (Object)drUnit, (Object)feUnit);
                this.radius_ = drUnit.convertTo(this.radius_, feUnit);
                if (!Double.isNaN(this.semimajor_)) {
                    this.semimajor_ = drUnit.convertTo(this.semimajor_, feUnit);
                }
                if (!Double.isNaN(this.semiminor_)) {
                    this.semiminor_ = drUnit.convertTo(this.semiminor_, feUnit);
                }
                radiusUnits = xUnits;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        LOGGER.trace("adj radius {} {}", (Object)this.radius_, (Object)radiusUnits);
        this.oneOverR_ = 1.0 / this.radius_;
    }

    @Override
    protected void setAxes() {
        CoordinateAxis xaxis = NcVarUtils.getCoordinateAxisOfType(this.ncvar_, NcAxisType.GEOX);
        CoordinateAxis yaxis = NcVarUtils.getCoordinateAxisOfType(this.ncvar_, NcAxisType.GEOY);
        if (xaxis == null || yaxis == null) {
            LOGGER.trace("Searching for CoordinateAxes by standard_name");
            xaxis = NcVarUtils.getCoordinateAxisWithStdName(this.njvarDS_, "projection_x_coordinate");
            yaxis = NcVarUtils.getCoordinateAxisWithStdName(this.njvarDS_, "projection_y_coordinate");
        }
        if (xaxis == null || yaxis == null) {
            LOGGER.trace("Must create CoordinateAxes");
            for (int i = 0; i < this.rank_; ++i) {
                Dimension d = this.njvarDS_.getDimension(i);
                String lcsname = d.getShortName().toLowerCase();
                String dfname = d.getFullName();
                if (dfname == null) continue;
                String lcfname = dfname.toLowerCase();
                VariableDS dimvar = this.getDataset().getVariableDS(dfname);
                if (dimvar == null) continue;
                if (lcsname.charAt(0) == 'x' || lcfname.contains("xdim") || lcfname.contains("cols")) {
                    xaxis = NcVarUtils.getCoordinateAxisOfType(dimvar, AxisType.GeoX);
                    continue;
                }
                if (lcsname.charAt(0) == 'y' || lcfname.contains("ydim") || lcfname.contains("rows")) {
                    yaxis = NcVarUtils.getCoordinateAxisOfType(dimvar, AxisType.GeoY);
                    continue;
                }
                Attribute standardA = dimvar.findAttribute("standard_name");
                if (standardA == null) continue;
                String lcStandard = standardA.getStringValue().toLowerCase();
                if ("projection_x_coordinate".equals(lcStandard)) {
                    xaxis = NcVarUtils.getCoordinateAxisOfType(dimvar, AxisType.GeoX);
                    continue;
                }
                if (!"projection_y_coordinate".equals(lcStandard)) continue;
                yaxis = NcVarUtils.getCoordinateAxisOfType(dimvar, AxisType.GeoY);
            }
        }
        if (xaxis == null || yaxis == null) {
            LOGGER.trace("GEOX or GEOY axis not found through third pass");
        }
        if (xaxis == null) {
            throw new NcException("Got null retrieving GEOX coordinate axis");
        }
        if (yaxis == null) {
            throw new NcException("Got null retrieving GEOY coordinate axis");
        }
        this.xAxis_ = new NcAxis(NcAxisType.GEOX, this.getDataset(), xaxis);
        this.yAxis_ = new NcAxis(NcAxisType.GEOY, this.getDataset(), yaxis);
        this.xDimNum_ = this.findDimensionIndex(xaxis);
        this.yDimNum_ = this.findDimensionIndex(yaxis);
        if (this.xDimNum_ == -1) {
            throw new NcException("Unable to determine dim num for GEOX axis");
        }
        if (this.yDimNum_ == -1) {
            throw new NcException("Unable to determine dim num for GEOY axis");
        }
    }

    public abstract Point2D.Double transformLL2XY(double var1, double var3);

    public abstract PointLL transformXY2LL(double var1, double var3);

    public double[] getBounds() {
        return new double[]{this.lBound_, this.tBound_, this.rBound_, this.bBound_};
    }

    @Override
    public int[] getEnclosingCell(double lon, double lat) {
        double halfdiff2;
        double diff2;
        double diff1;
        Point2D.Double altXY = this.transformLL2XY(lon, lat);
        double x = altXY.x;
        double y = altXY.y;
        double[] xValues = this.getXAxis().getValues();
        double[] yValues = this.getYAxis().getValues();
        int imax = xValues.length - 1;
        int jmax = yValues.length - 1;
        int col = -1;
        int row = -1;
        if (NcArrayLonLatProjected.isBetween(x, xValues[0], xValues[imax])) {
            for (int i = 0; i < imax; ++i) {
                if (!NcArrayLonLatProjected.isBetween(x, xValues[i], xValues[i + 1])) continue;
                diff1 = Math.abs(x - xValues[i]);
                col = diff1 <= (diff2 = Math.abs(x - xValues[i + 1])) ? i : i + 1;
                break;
            }
        } else {
            double halfdiff1 = 0.5 * (xValues[1] - xValues[0]);
            halfdiff2 = 0.5 * (xValues[imax] - xValues[imax - 1]);
            if (NcArrayLonLatProjected.isBetween(x, xValues[0], xValues[0] - halfdiff1)) {
                col = 0;
            }
            if (NcArrayLonLatProjected.isBetween(x, xValues[imax], xValues[imax] + halfdiff2)) {
                col = imax;
            }
        }
        if (NcArrayLonLatProjected.isBetween(y, yValues[0], yValues[jmax])) {
            for (int j = 0; j < jmax; ++j) {
                if (!NcArrayLonLatProjected.isBetween(y, yValues[j], yValues[j + 1])) continue;
                diff1 = Math.abs(y - yValues[j]);
                row = diff1 <= (diff2 = Math.abs(y - yValues[j + 1])) ? j : j + 1;
                break;
            }
        } else {
            double halfdiff1 = 0.5 * (yValues[1] - yValues[0]);
            halfdiff2 = 0.5 * (yValues[jmax] - yValues[jmax - 1]);
            if (NcArrayLonLatProjected.isBetween(y, yValues[0], yValues[0] - halfdiff1)) {
                row = 0;
            }
            if (NcArrayLonLatProjected.isBetween(y, yValues[jmax], yValues[jmax] + halfdiff2)) {
                row = jmax;
            }
        }
        if (col == -1 || row == -1) {
            return null;
        }
        return new int[]{col, row};
    }

    private static boolean isBetween(double value, double range1, double range2) {
        return value >= range1 && value <= range2 || value <= range1 && value >= range2;
    }

    @Override
    public NcGridder getGridder() {
        return new NcGridderLonLatProjected();
    }

    @Override
    public void describeCell(StringBuilder sb, PrintfFormat valFormat, int ... index) {
        Objects.requireNonNull(index, "Cell index cannot be null.");
        int col = index[0];
        int row = index[1];
        if (col < 0 || row < 0) {
            sb.append("Pt apparently outside data bounds");
            return;
        }
        double x = this.getXAxis().valueAt(col);
        double y = this.getYAxis().valueAt(row);
        LOGGER.trace("{},{}", (Object)x, (Object)y);
        PointLL ll2 = this.transformXY2LL(x, y);
        LOGGER.trace("---> {}", (Object)ll2);
        if (ll2 == null) {
            sb.append("Got null for lon-lat?");
            return;
        }
        double lon = ll2.getLon();
        double lat = ll2.getLat();
        double gv = this.valueAt(col, row);
        sb.append("Cell ").append('[').append(col + 1).append(',').append(row + 1).append(']').append(" at [").append(NcStringUtils.formatLongitude(lon)).append(' ').append(NcStringUtils.formatLatitude(lat)).append(']').append(" (alt [").append(PrintfFormat.PFORMAT_7G.sprintfx(this.getXAxis().valueAt(col))).append(',').append(PrintfFormat.PFORMAT_7G.sprintfx(this.getYAxis().valueAt(row))).append("]),");
        sb.append(" value = ").append(valFormat.sprintfx(gv));
        if (Double.isNaN(gv)) {
            return;
        }
        String unitsStr = this.getUnitsString();
        if (unitsStr != null && !unitsStr.isEmpty() && !unitsStr.equals("1")) {
            sb.append(' ').append(unitsStr);
        }
    }

    protected static Point2D.Double transformNjLL2XY(Projection njproj, double lon, double lat) {
        if (NcArrayLonLat.isBadLatitude(lat)) {
            return null;
        }
        LatLonPoint njll = LatLonPoint.create(lat, lon);
        ProjectionPoint xy = njproj.latLonToProj(njll);
        return new Point2D.Double(xy.getX(), xy.getY());
    }

    protected static PointLL transformNjXY2LL(Projection njproj, double x, double y) {
        LatLonPoint njll = njproj.projToLatLon(x, y);
        if (njll == null) {
            return null;
        }
        return new PointLL(njll.getLongitude(), njll.getLatitude());
    }

    @Override
    public LonLatEdges getLonLatEdges() {
        LOGGER.warn("Not yet implemented.");
        return null;
    }
}

