/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc.array;

import gov.nasa.giss.data.nc.NcArray;
import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.NcAxisType;
import gov.nasa.giss.data.nc.NcDimension;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcTimeAxis;
import gov.nasa.giss.data.nc.NcVarUtils;
import gov.nasa.giss.data.nc.NcVariable;
import gov.nasa.giss.data.nc.gridder.NcGridder;
import gov.nasa.giss.data.nc.gridder.NcGridder1D;
import gov.nasa.giss.text.PrintfFormat;
import gov.nasa.giss.time.UnixTimeFormatter;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Dimension;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.VariableDS;

public class NcArray1D
extends NcArray {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected NcAxis axis_;
    private int axDimNum_ = -1;
    private int axLength_ = -1;
    private int aveDimNum_ = -1;
    private int numAves_ = -1;
    private double[] averages_;

    public NcArray1D(NcVariable ncvar, Object axisInfo) throws NcException {
        super(ncvar);
        this.initMe(axisInfo);
    }

    private void initMe(Object axisInfo) {
        Dimension d;
        int i;
        LOGGER.trace("{}", axisInfo);
        Dimension axDim = null;
        VariableDS axCV = null;
        boolean usesSecondaryTimeAxis = false;
        if (axisInfo == null) {
            for (int i2 = 0; i2 < this.rank_; ++i2) {
                if (this.shape_[i2] <= 1) continue;
                this.axDimNum_ = i2;
                break;
            }
        } else if (axisInfo instanceof Integer) {
            this.axDimNum_ = (Integer)axisInfo;
            LOGGER.trace("axDimNum_ {}", (Object)this.axDimNum_);
            if (this.axDimNum_ < 0 || this.axDimNum_ > this.rank_) {
                throw new IndexOutOfBoundsException("AxisInfo Index out of range.");
            }
        } else if (axisInfo instanceof NcDimension) {
            Dimension dd = ((NcDimension)axisInfo).getNjDimension();
            for (i = 0; i < this.rank_; ++i) {
                d = this.njvarDS_.getDimension(i);
                if (!d.equals(dd)) continue;
                axDim = d;
                this.axDimNum_ = i;
                break;
            }
        } else if (axisInfo instanceof NcVariable || axisInfo instanceof VariableDS) {
            VariableDS njvar = null;
            if (axisInfo instanceof NcVariable) {
                NcVariable ncvar = (NcVariable)axisInfo;
                njvar = (VariableDS)ncvar.getObject();
            } else {
                njvar = (VariableDS)axisInfo;
            }
            int rank = njvar.getRank();
            if (rank == 1 && NcVarUtils.isUnixTime(njvar)) {
                Dimension dd = njvar.getDimension(0);
                for (int i3 = 0; i3 < this.rank_; ++i3) {
                    Dimension d2 = this.njvarDS_.getDimension(i3);
                    if (!d2.equals(dd)) continue;
                    usesSecondaryTimeAxis = true;
                    axCV = njvar;
                    axDim = d2;
                    this.axDimNum_ = i3;
                    break;
                }
            } else {
                LOGGER.trace("AxisInfo is NcVariable but apparently not 1D time.");
            }
        } else if (axisInfo instanceof String) {
            String dname = (String)axisInfo;
            for (i = 0; i < this.rank_; ++i) {
                d = this.njvarDS_.getDimension(i);
                String sname = d.getShortName();
                String fname = d.getFullName();
                if (!dname.equals(sname) && !dname.equals(fname)) continue;
                axDim = d;
                this.axDimNum_ = i;
                break;
            }
        } else {
            throw new IllegalArgumentException("Unintelligible axis info.");
        }
        LOGGER.trace("axDimNum  {}", (Object)this.axDimNum_);
        if (this.axDimNum_ < 0) {
            throw new NcException("No matching axis dimension found.");
        }
        if (this.shape_[this.axDimNum_] < 2) {
            throw new NcException("Axis dimension is too short.");
        }
        if (axDim == null) {
            axDim = this.njvarDS_.getDimension(this.axDimNum_);
        }
        if (axCV == null) {
            axCV = this.dataset_.getCoordinateVariable(axDim);
        }
        LOGGER.trace("CV {}", (Object)axCV);
        if (axCV == null) {
            LOGGER.trace("Axis CV not found.");
            String fname = axDim.getShortName();
            int length = axDim.getLength();
            this.axis_ = new NcAxis(NcAxisType.GEOX, fname, length);
        } else if (usesSecondaryTimeAxis) {
            LOGGER.trace("Axis CV looks like secondary time.");
            try {
                this.axis_ = new NcTimeAxis(this.dataset_, axCV);
            }
            catch (Exception exc) {
                LOGGER.warn("Exception creating secondary NcTimeAxis: ", (Object)exc.toString());
                if (LOGGER.isTraceEnabled()) {
                    exc.printStackTrace();
                }
            }
        } else {
            if (NcVarUtils.isUnixTime(axCV)) {
                LOGGER.trace("Axis CV looks like time.");
                try {
                    CoordinateAxis ca = NcVarUtils.getCoordinateAxisOfType(axCV, AxisType.Time);
                    this.axis_ = new NcTimeAxis(this.dataset_, ca);
                }
                catch (Exception exc) {
                    LOGGER.warn("Exception getting time CoordinateAxis: {}", (Object)exc.toString());
                    if (LOGGER.isTraceEnabled()) {
                        exc.printStackTrace();
                    }
                }
            } else if (NcVarUtils.isPressure(axCV) || NcVarUtils.isHeight(axCV) || NcVarUtils.isDepth(axCV)) {
                LOGGER.trace("Axis CV looks like vert.");
                this.axis_ = new NcAxis(NcAxisType.VERT, this.dataset_, axCV);
            }
            if (this.axis_ == null) {
                LOGGER.trace("Not clear what axis CV type is. Calling it GEOX.");
                this.axis_ = new NcAxis(NcAxisType.GEOX, this.dataset_, axCV);
            }
        }
        LOGGER.trace("axis_ {}", (Object)this.axis_.getClass());
        CoordinateAxis lonaxis = NcVarUtils.getCoordinateAxisOfType(this.ncvar_, NcAxisType.LON);
        LOGGER.trace("lonaxis {}", (Object)(lonaxis != null ? 1 : 0));
        if (lonaxis != null && lonaxis.getRank() == 1 && lonaxis.getShape()[0] > 0) {
            this.aveDimNum_ = this.findDimensionIndex(lonaxis);
            if (this.aveDimNum_ == this.axDimNum_) {
                this.aveDimNum_ = -1;
            } else {
                Dimension dd = this.njvarDS_.getDimension(this.aveDimNum_);
                if (dd == null) {
                    this.aveDimNum_ = -1;
                } else {
                    VariableDS dimVar = this.dataset_.getCoordinateVariable(dd);
                    if (!lonaxis.equals(dimVar)) {
                        this.aveDimNum_ = -1;
                    }
                }
            }
        }
        LOGGER.trace("aveDimNum {}", (Object)this.aveDimNum_);
        this.measureAxes();
        if (this.aveDimNum_ > -1) {
            this.setSliceIndex(this.aveDimNum_, -1);
        }
        this.needsSlice_ = true;
        this.valueAt(0);
    }

    private void measureAxes() {
        if (this.axDimNum_ < 0) {
            throw new NcException("X-dimension index is not set.");
        }
        this.axLength_ = this.shape_[this.axDimNum_];
        if (this.aveDimNum_ > -1) {
            this.numAves_ = this.shape_[this.aveDimNum_];
        }
    }

    @Override
    protected void createFreeDimensions() {
        if (this.dimensions_ != null) {
            return;
        }
        this.dimensions_ = new NcDimension[this.rank_];
        for (int i = 0; i < this.rank_; ++i) {
            this.dimensions_[i] = i == this.axDimNum_ ? null : this.ncvar_.getDimension(i);
        }
    }

    public int getLength() {
        return this.axLength_;
    }

    public NcAxis getAxis() {
        return this.axis_;
    }

    public int getDimensionIndex() {
        return this.axDimNum_;
    }

    public boolean isAxisUnixTime() {
        if (this.axis_ instanceof NcTimeAxis) {
            NcTimeAxis tax = (NcTimeAxis)this.axis_;
            return tax.isUnixTime();
        }
        return false;
    }

    public boolean isAxisPressure() {
        return this.axis_.isPressure();
    }

    public String getAxisFormatPattern() {
        if (this.axis_ instanceof NcTimeAxis) {
            NcTimeAxis tax = (NcTimeAxis)this.axis_;
            UnixTimeFormatter tt = (UnixTimeFormatter)tax.getFormatter();
            return tt.getPattern();
        }
        return null;
    }

    public void setAxisFormatPattern(String pattern) {
        NcTimeAxis tax;
        if (this.axis_ instanceof NcTimeAxis && (tax = (NcTimeAxis)this.axis_).isUnixTime()) {
            UnixTimeFormatter tt = (UnixTimeFormatter)tax.getFormatter();
            tt.applyPattern(pattern);
            return;
        }
        LOGGER.debug("Axis does not accept a time pattern");
    }

    @Override
    public boolean isAveragingDimension(int dimIndex) {
        return dimIndex == this.aveDimNum_;
    }

    public double valueAt(int index) {
        if (index < 0 || index >= this.axLength_) {
            throw new IndexOutOfBoundsException("Index out of range: " + index + " : " + this.axLength_);
        }
        if (this.aveDimNum_ > -1 && this.sIndex_[this.aveDimNum_] == -1) {
            return this.dimensionAverageAt(index);
        }
        if (this.needsSlice_ || this.slice_ == null) {
            this.doSlice();
        }
        try {
            double dd = this.getDoubleFromSlice(index, -1);
            if (Double.isNaN(dd) || this.isMissingOrInvalid(dd)) {
                return Double.NaN;
            }
            return dd;
        }
        catch (Exception exc) {
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            throw new NcException(exc.toString());
        }
    }

    public double dimensionAverageAt(int index) throws NcException {
        if (this.aveDimNum_ == -1) {
            throw new NcException("Dimension averaging not set up for this array.");
        }
        if (this.averages_ == null) {
            this.doAverage();
        }
        return this.averages_[index];
    }

    private synchronized void doSlice() throws NcException {
        int[] sOrigin = new int[this.rank_];
        int[] sShape = new int[this.rank_];
        try {
            this.needsSlice_ = true;
            for (int i = 0; i < this.rank_; ++i) {
                sOrigin[i] = this.sIndex_[i];
                sShape[i] = 1;
            }
            sOrigin[this.axDimNum_] = 0;
            sShape[this.axDimNum_] = this.axLength_;
            LOGGER.trace("axDimNum {}", (Object)this.axDimNum_);
            if (this.rank_ > 1) {
                LOGGER.trace("sOrigin  {}, {}", (Object)sOrigin[0], (Object)sOrigin[1]);
                LOGGER.trace("sShape   {}, {}", (Object)sShape[0], (Object)sShape[1]);
            } else {
                LOGGER.trace("sOrigin  {}", (Object)sOrigin[0]);
                LOGGER.trace("sShape   {}", (Object)sShape[0]);
            }
            this.slice_ = this.njvarDS_.read(sOrigin, sShape);
            this.sliceIdx_ = this.slice_.getIndex();
            this.needsSlice_ = false;
        }
        catch (Exception exc) {
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            throw new NcException("Do Slice - " + exc.toString());
        }
    }

    private void doAverage() throws NcException {
        int i;
        LOGGER.trace("aveDimNum {}", (Object)this.aveDimNum_);
        if (this.aveDimNum_ < 0) {
            throw new NcException("Array has no averaging dimension.");
        }
        this.slice_ = null;
        if (this.averages_ == null) {
            this.averages_ = new double[this.axLength_];
        }
        int[] sOrigin = new int[this.rank_];
        int[] sShape = new int[this.rank_];
        int[] aveCount = new int[this.axLength_];
        for (i = 0; i < this.axLength_; ++i) {
            this.averages_[i] = 0.0;
            aveCount[i] = 0;
        }
        try {
            for (i = 0; i < this.rank_; ++i) {
                sOrigin[i] = this.sIndex_[i];
                sShape[i] = 1;
            }
            sOrigin[this.axDimNum_] = 0;
            sShape[this.axDimNum_] = this.axLength_;
            for (int iave = 0; iave < this.numAves_; iave += this.numAves_) {
                sOrigin[this.aveDimNum_] = iave;
                sShape[this.aveDimNum_] = this.numAves_;
                this.slice_ = this.njvarDS_.read(sOrigin, sShape);
                this.sliceIdx_ = this.slice_.getIndex();
                for (int mm = 0; mm < this.numAves_; ++mm) {
                    for (int j = 0; j < this.axLength_; ++j) {
                        double dval = this.getDoubleFromSlice(j, mm);
                        if (this.isMissingOrInvalid(dval)) continue;
                        int n = j;
                        this.averages_[n] = this.averages_[n] + dval;
                        int n2 = j;
                        aveCount[n2] = aveCount[n2] + 1;
                    }
                }
                this.slice_ = null;
            }
        }
        catch (Exception exc) {
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            throw new NcException("Do Average: " + exc.toString());
        }
        for (int j = 0; j < this.axLength_; ++j) {
            if (aveCount[j] == 0) {
                this.averages_[j] = Double.NaN;
                continue;
            }
            if (aveCount[j] <= 1) continue;
            int n = j;
            this.averages_[n] = this.averages_[n] / (double)aveCount[j];
        }
        this.needsSlice_ = false;
    }

    @Override
    public void setSliceIndex(int dimNum, int index) {
        if (dimNum != this.aveDimNum_ || index == -1) {
            this.averages_ = null;
        }
        super.setSliceIndex(dimNum, index);
    }

    @Override
    protected void findExtrema() {
        double[] range;
        if (this.rank_ < 3 && (range = this.getActualRange()) != null) {
            this.minimum_ = range[0];
            this.maximum_ = range[1];
            this.needsExtrema_ = false;
            return;
        }
        this.minimum_ = Double.POSITIVE_INFINITY;
        this.maximum_ = Double.NEGATIVE_INFINITY;
        try {
            for (int j = 0; j < this.axLength_; ++j) {
                double value = this.valueAt(j);
                if (this.isMissingOrInvalid(value)) continue;
                if (this.maximum_ < this.minimum_) {
                    this.minimum_ = value;
                    this.maximum_ = value;
                    continue;
                }
                if (value < this.minimum_) {
                    this.minimum_ = value;
                    continue;
                }
                if (!(value > this.maximum_)) continue;
                this.maximum_ = value;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Double.isInfinite(this.minimum_)) {
            this.minimum_ = Double.NaN;
            this.maximum_ = Double.NaN;
        }
        this.needsExtrema_ = false;
    }

    private double getDoubleFromSlice(int index, int ave) {
        int[] ss = new int[this.rank_];
        for (int i = 0; i < this.rank_; ++i) {
            ss[i] = 0;
        }
        ss[this.axDimNum_] = index;
        if (ave > -1) {
            ss[this.aveDimNum_] = ave;
        }
        this.sliceIdx_.set(ss);
        return this.slice_.getDouble(this.sliceIdx_);
    }

    @Override
    public NcGridder getGridder() {
        return new NcGridder1D();
    }

    @Override
    public void describeCell(StringBuilder sb, PrintfFormat valFormat, int ... index) {
    }
}

