/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc;

import com.google.common.collect.ImmutableList;
import gov.nasa.giss.data.nc.NcAxisType;
import gov.nasa.giss.data.nc.NcCartesianVarType;
import gov.nasa.giss.data.nc.NcCoordinateVarType;
import gov.nasa.giss.data.nc.NcDataGrouping;
import gov.nasa.giss.data.nc.NcDataNode;
import gov.nasa.giss.data.nc.NcDimension;
import gov.nasa.giss.data.nc.NcDiscreteVarType;
import gov.nasa.giss.data.nc.NcException;
import gov.nasa.giss.data.nc.NcLLAltGriddingVarType;
import gov.nasa.giss.data.nc.NcUtils;
import gov.nasa.giss.data.nc.NcVarType;
import gov.nasa.giss.data.nc.NcVarTypeDetector;
import gov.nasa.giss.data.nc.NcVarUtils;
import gov.nasa.giss.text.StringUtils;
import gov.nasa.giss.ui.treetable.TreeTableNode;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayString;
import ucar.ma2.DataType;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.VariableEnhanced;

public class NcVariable
extends NcDataNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected VariableDS njvarDS_;
    protected int rank_;
    protected int[] shape_;
    protected NcVarType varType_;
    protected NcCoordinateVarType cvarType_;
    private NcDimension[] ncdims_;
    protected Array extractSlice_;
    protected int[] extractOrigin_;
    protected int[] extractShape_;

    public NcVariable(NcDataGrouping ncg, VariableDS njvarDS) {
        super(ncg);
        this.njvarDS_ = njvarDS;
        this.rank_ = this.njvarDS_.getRank();
        this.shape_ = this.njvarDS_.getShape();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof NcVariable)) {
            return false;
        }
        NcVariable var2 = (NcVariable)o;
        return this.njvarDS_.equals(var2.getObject());
    }

    public int hashCode() {
        return this.njvarDS_.hashCode();
    }

    public NcDataGrouping getGrouping() {
        NcDataNode parent = this.getNcParent();
        if (parent == null) {
            LOGGER.error("Parent data node is null.");
            return null;
        }
        if (!(parent instanceof NcDataGrouping)) {
            LOGGER.error("Parent data node is not a data grouping?");
            return null;
        }
        return (NcDataGrouping)parent;
    }

    public NcVarType getVarType() {
        if (this.varType_ == null) {
            this.initVarType();
        }
        return this.varType_;
    }

    private void initVarType() {
        try {
            NcDataNode parent = this.getNcParent();
            this.varType_ = NcVarTypeDetector.getVarType(this.ncdataset_, (NcDataGrouping)parent, this.njvarDS_);
        }
        catch (Exception exc) {
            LOGGER.warn("Exception getting var type for {}, {}", (Object)this.njvarDS_.getShortName(), (Object)exc.toString());
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            this.varType_ = NcVarType.OTHER;
        }
    }

    public NcCoordinateVarType getCoordinateVarType() {
        if (this.cvarType_ == null) {
            try {
                this.cvarType_ = NcVarTypeDetector.getCoordinateVarType(this.njvarDS_);
            }
            catch (Exception exc) {
                this.cvarType_ = NcCoordinateVarType.NONE;
            }
        }
        return this.cvarType_;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public boolean getAllowsChildren() {
        return false;
    }

    @Override
    public Object getObject() {
        return this.njvarDS_;
    }

    @Override
    public String getName() {
        return this.getShortName();
    }

    @Override
    public String getNjPath() {
        return this.njvarDS_.getFullName();
    }

    @Override
    public String getShortName() {
        return this.njvarDS_.getShortName();
    }

    @Override
    public String getLongName() {
        return NcVarUtils.getLongName(this.njvarDS_);
    }

    public String getUnitsString() {
        return NcVarUtils.getUnitsString(this.njvarDS_);
    }

    @Override
    public String getNcType() {
        String result = null;
        result = this.isTrajectory() ? "GeoTraj" : (this.isGriddable2DGeo() ? "Geo2D" : (this.isGriddable2D() ? "2D" : (this.isGriddable1D() ? "1D" : "\u2014")));
        if (this.varType_ == null) {
            this.initVarType();
        }
        LOGGER.trace("{} = {} = {}", this.njvarDS_.getShortName(), this.varType_, result);
        return result;
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public TreeTableNode[] getChildren() {
        return null;
    }

    @Override
    public String toString() {
        return this.njvarDS_.getFullName();
    }

    @Override
    public String getDetail(boolean enhanced) {
        if (this.varType_ == null) {
            this.initVarType();
        }
        String sname = this.njvarDS_.getShortName();
        String fname = this.njvarDS_.getFullName();
        Variable varUnenhanced = this.ncdataset_.getNjVariableUnenhanced(fname);
        Variable varOriginal = this.njvarDS_.getOriginalVariable();
        boolean doubleEnhanced = false;
        if (varOriginal instanceof VariableEnhanced) {
            LOGGER.trace("Original variable is double enhanced!");
            doubleEnhanced = true;
            varOriginal = ((VariableEnhanced)((Object)varOriginal)).getOriginalVariable();
        }
        StringBuilder sb = new StringBuilder(256);
        sb.append("<html>").append("<head>");
        this.appendDetailStyle(sb);
        sb.append("</head>").append("<body>").append("<h2>Variable \"").append(sname).append("\"</h2>").append("<h3>In file \"").append(this.ncdataset_.getName()).append("\"</h3>");
        if (!sname.equals(fname)) {
            sb.append("<p>Variable full name: ").append(fname).append("</p>");
        }
        if (enhanced || varUnenhanced == null && varOriginal == null) {
            if (doubleEnhanced) {
                sb.append("<p>Variable appears to be 'double enhanced'.</p>");
            } else if (varUnenhanced == null && varOriginal == null) {
                sb.append("<p>Variable appears to be 'virtual', constructed based on file metadata.</p>");
            } else {
                sb.append("<p><b>Showing enhanced mode description.</b></p>");
            }
            sb.append("<p>Variable type for plotting is ").append(this.varType_).append("</p>");
            sb.append("<pre>").append(StringUtils.escapeHtmlSimplistic(this.njvarDS_.toString())).append("</pre>");
        } else {
            sb.append("<pre>");
            if (varUnenhanced != null) {
                sb.append(StringUtils.escapeHtmlSimplistic(varUnenhanced.toString()));
            } else {
                sb.append(StringUtils.escapeHtmlSimplistic(varOriginal.toString()));
            }
            sb.append("</pre>");
        }
        if (enhanced) {
            sb.append("<hr>");
            List csList = this.njvarDS_.getCoordinateSystems();
            if (csList == null) {
                sb.append("<p>No coordinate systems reported.</p>");
            } else {
                int csCount = csList.size();
                if (csCount == 1) {
                    sb.append("<p>1 coordinate system reported.</p>");
                } else {
                    sb.append("<p>").append(csCount).append(" coordinate systems reported.</p>");
                }
                for (int i = 0; i < csCount; ++i) {
                    CoordinateSystem cs = (CoordinateSystem)csList.get(i);
                    sb.append("<pre>Coordinate System ").append(i);
                    if (cs == null) {
                        sb.append(" is null.");
                    } else {
                        sb.append("\n");
                        ImmutableList<CoordinateAxis> axes = cs.getCoordinateAxes();
                        int axCount = axes.size();
                        for (int j = 0; j < axCount; ++j) {
                            CoordinateAxis ax = (CoordinateAxis)axes.get(j);
                            sb.append("\n").append(j).append(". ").append(ax.getFullName()).append("\n").append("   AxisType ").append((Object)ax.getAxisType()).append("\n").append("   Rank ").append(ax.getRank()).append("\n").append("   Is CV ").append(ax.isCoordinateVariable()).append("\n");
                        }
                    }
                    sb.append("</pre>");
                }
            }
        }
        DataType njtype = this.njvarDS_.getDataType();
        if (this.isEffectivelyScalar()) {
            this.appendScalarInfo(sb, enhanced, varUnenhanced, varOriginal);
        } else if (njtype == DataType.CHAR || njtype == DataType.STRING) {
            this.appendCharStringInfo(sb);
        } else if (this.isTrajectory()) {
            this.appendTrajectoryWarning(sb);
        }
        if (LOGGER.isDebugEnabled()) {
            this.appendDebugInfo(sb);
        }
        sb.append("</body>");
        sb.append("</html>");
        return sb.toString();
    }

    @Override
    public String getDetailType() {
        return "text/html";
    }

    private void appendScalarInfo(StringBuilder sb, boolean enhanced, Variable varUnenhanced, Variable varOriginal) {
        block7: {
            try {
                Object oo2;
                Object oo1 = this.getScalarValue(this.njvarDS_);
                Object object = oo2 = varUnenhanced != null ? this.getScalarValue(varUnenhanced) : this.getScalarValue(varOriginal);
                if (oo1 == null) {
                    LOGGER.trace("getScalarValue returned null");
                    return;
                }
                sb.append("<hr>").append("<p>");
                if (this.njvarDS_.isScalar()) {
                    sb.append("Scalar variable has value: ");
                } else {
                    sb.append("Array is single-valued, with value: ");
                }
                NcUtils.appendScalarObjectValue(sb, oo1);
                if (enhanced && oo2 != null) {
                    sb.append("<br>").append("Unenhanced value is: ");
                    NcUtils.appendScalarObjectValue(sb, oo2);
                }
                sb.append("</p>");
            }
            catch (Exception exc) {
                if (LOGGER.isDebugEnabled()) {
                    sb.append("<hr>").append("<p>").append("Exception occurred extracting variable's scalar value: ").append(exc.toString()).append("</p>");
                }
                LOGGER.debug("Could not extract scalar value: {}", (Object)exc.toString());
                if (!LOGGER.isTraceEnabled()) break block7;
                exc.printStackTrace();
            }
        }
    }

    private void appendCharStringInfo(StringBuilder sb) {
        block14: {
            long ichars = this.njvarDS_.getSize();
            if (ichars > 100000L) {
                LOGGER.debug("Character array or String is too long to include.");
                return;
            }
            DataType njtype = this.njvarDS_.getDataType();
            if (njtype == DataType.CHAR && this.rank_ < 2) {
                try {
                    Array aarray = this.njvarDS_.read();
                    ArrayChar carray = (ArrayChar)aarray;
                    String ss = carray.toString();
                    sb.append("<p>Char content reads:</p>").append("<pre>").append(StringUtils.escapeHtmlSimplistic(ss)).append("</pre>");
                }
                catch (Exception exc) {
                    if (LOGGER.isDebugEnabled()) {
                        sb.append("<hr>").append("<p>").append("An exception occurred while extracting char (array) value: ").append(exc.toString()).append("</p>");
                    }
                    LOGGER.debug("Could not extract Character array: {}", (Object)exc.toString());
                    if (LOGGER.isTraceEnabled()) {
                        exc.printStackTrace();
                    }
                    break block14;
                }
            }
            if (njtype == DataType.STRING) {
                LOGGER.debug("Yo, it's a String");
                try {
                    Array aarray = this.njvarDS_.read().reduce();
                    if (aarray instanceof ArrayString.D0) {
                        ArrayString.D0 sarray = (ArrayString.D0)aarray;
                        sb.append("<p>String reads:</p>").append("<pre>").append(sarray.get()).append("</pre>");
                    } else if (aarray instanceof ArrayString) {
                        LOGGER.warn("Array is ArrayString, but not D0.");
                    } else {
                        LOGGER.warn("DataType says String, but Array is not ArrayString.");
                    }
                }
                catch (Exception exc) {
                    if (LOGGER.isDebugEnabled()) {
                        sb.append("<hr>").append("<p>").append("An exception occurred while extracting string value: ").append(exc.toString()).append("</p>");
                    }
                    LOGGER.debug("Could not extract String: {}", (Object)exc.toString());
                    if (!LOGGER.isTraceEnabled()) break block14;
                    exc.printStackTrace();
                }
            }
        }
    }

    private void appendTrajectoryWarning(StringBuilder sb) {
        int[] shape = this.njvarDS_.getShape();
        boolean big = false;
        boolean verybig = false;
        for (int i = 0; i < shape.length; ++i) {
            if (shape[i] > 50000) {
                big = true;
            }
            if (shape[i] <= 200000) continue;
            verybig = true;
        }
        if (verybig) {
            sb.append("<hr>").append("<p>").append("Trajectory variable contains more than 200k elements; ").append("plotting it could be extremely slow.</p>");
        } else if (big) {
            sb.append("<hr>").append("<p>").append("Trajectory variable contains more than 50k elements; ").append("plotting it could be slow.</p>");
        }
    }

    private void appendDebugInfo(StringBuilder sb) {
        sb.append("<hr>").append("<p><b>Debug info:</b></p>\n").append("<pre>").append("isCoordinateVar ").append(this.njvarDS_.isCoordinateVariable()).append('\n').append("hasFillValue    ").append(this.njvarDS_.hasFillValue()).append('\n').append("hasMissing      ").append(this.njvarDS_.hasMissing()).append('\n').append("hasMissingValue ").append(this.njvarDS_.hasMissingValue()).append('\n').append("getValidMin     ").append(this.njvarDS_.getValidMin()).append('\n').append("getValidMax     ").append(this.njvarDS_.getValidMax()).append('\n');
        Formatter ff = new Formatter();
        this.njvarDS_.showScaleMissingProxy(ff);
        sb.append('\n').append("S-M-P...\n").append(ff).append('\n');
        sb.append("</pre>");
    }

    public boolean isGriddable() {
        if (this.isTrajectory()) {
            return true;
        }
        return this.isGriddable1D() || this.isGriddable2D() || this.isGriddable2DGeo();
    }

    public boolean isGriddable1D() {
        if (this.varType_ == null) {
            this.initVarType();
        }
        if (this.varType_ == NcVarType.OTHER || this.varType_ == NcVarType.SCALAR) {
            return false;
        }
        return NcVarUtils.isGriddable1D(this.njvarDS_);
    }

    public boolean isGriddable2D() {
        if (!this.isGriddable1D()) {
            return false;
        }
        if (this.varType_ == NcVarType.ONED) {
            return false;
        }
        return NcVarUtils.isGriddable2D(this.njvarDS_);
    }

    public boolean isGriddable2DGeo() {
        if (this.varType_ == null) {
            this.initVarType();
        }
        return this.varType_.isGeoreferenced() && !this.isTrajectory();
    }

    public boolean isTrajectory() {
        if (this.varType_ == null) {
            this.initVarType();
        }
        if (this.varType_ instanceof NcDiscreteVarType) {
            return ((NcDiscreteVarType)this.varType_).isTrajectory();
        }
        return false;
    }

    public boolean hasAxesOfType(NcAxisType atype1, NcAxisType atype2) {
        if (this.varType_ == null) {
            this.initVarType();
        }
        if (this.varType_ instanceof NcCartesianVarType) {
            NcCartesianVarType cvtype = (NcCartesianVarType)this.varType_;
            return cvtype.hasAxis(atype1) && cvtype.hasAxis(atype2);
        }
        if (this.varType_ instanceof NcLLAltGriddingVarType) {
            return atype1 == NcAxisType.LON && atype2 == NcAxisType.LAT || atype1 == NcAxisType.LAT && atype2 == NcAxisType.LON;
        }
        return false;
    }

    private boolean isEffectivelyScalar() {
        if (this.varType_ == null) {
            this.initVarType();
        }
        return this.varType_ == NcVarType.SCALAR;
    }

    public int getRank() {
        return this.rank_;
    }

    public int[] getShape() {
        return this.shape_;
    }

    public long getElementCount() {
        long count = 1L;
        for (int i = 0; i < this.rank_; ++i) {
            count *= (long)this.shape_[i];
        }
        return count;
    }

    public NcDimension getDimension(int index) {
        if (this.ncdims_ == null) {
            this.extractDimensions();
        }
        return this.ncdims_[index];
    }

    public NcDimension[] getDimensions() {
        if (this.ncdims_ == null) {
            this.extractDimensions();
        }
        return this.ncdims_;
    }

    public NcDimension[] getNumericDimensions() {
        if (this.ncdims_ == null) {
            this.extractDimensions();
        }
        ArrayList<NcDimension> ndims = new ArrayList<NcDimension>(this.rank_);
        for (int i = 0; i < this.rank_; ++i) {
            if (NcVarUtils.isApparentNumericDimension(this.njvarDS_, i)) {
                ndims.add(this.ncdims_[i]);
                continue;
            }
            ndims.add(null);
        }
        return ndims.toArray(new NcDimension[0]);
    }

    private void extractDimensions() {
        this.ncdims_ = new NcDimension[this.rank_];
        for (int i = 0; i < this.rank_; ++i) {
            Dimension d = this.njvarDS_.getDimension(i);
            this.ncdims_[i] = new NcDimension(this.ncdataset_, this.njvarDS_, d);
        }
    }

    public double doubleValueAt(int ... indices) {
        Double oo = this.objectAt(indices);
        if (oo == null) {
            return Double.NaN;
        }
        return NcUtils.objectValueToDouble(oo);
    }

    private double objectAt(int ... indices) {
        if (this.isEffectivelyScalar()) {
            if (indices == null || indices.length == 0) {
                return NcUtils.objectValueToDouble(this.getScalarValue(this.njvarDS_));
            }
            throw new IllegalArgumentException("Indices are unnecessary. Variable is a scalar.");
        }
        if (indices.length != this.rank_) {
            throw new IllegalArgumentException("Indices array is wrong rank.");
        }
        boolean needsExtract = false;
        if (this.extractOrigin_ == null) {
            this.extractOrigin_ = new int[this.rank_];
            this.extractShape_ = new int[this.rank_];
            needsExtract = true;
        }
        int rankM1 = this.rank_ - 1;
        for (int i = 0; i < rankM1; ++i) {
            if (indices[i] < 0 || indices[i] >= this.shape_[i]) {
                throw new IndexOutOfBoundsException("Index " + indices[i] + " out of range 0," + (this.shape_[i] - 1) + " for dimension " + i);
            }
            if (indices[i] != this.extractOrigin_[i]) {
                needsExtract = true;
            }
            this.extractOrigin_[i] = indices[i];
            this.extractShape_[i] = 1;
        }
        this.extractOrigin_[rankM1] = 0;
        this.extractShape_[rankM1] = this.shape_[rankM1];
        try {
            if (needsExtract) {
                this.extractSlice_ = this.njvarDS_.read(this.extractOrigin_, this.extractShape_).reduce();
            }
            Object oo = this.extractSlice_.getObject(indices[rankM1]);
            return NcUtils.objectValueToDouble(oo);
        }
        catch (Exception exc) {
            LOGGER.warn("Exception occurred extracting double value: {}", (Object)exc.toString());
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            return Double.NaN;
        }
    }

    private Object getScalarValue(Variable njvar) {
        if (njvar == null) {
            return null;
        }
        if (!this.isEffectivelyScalar()) {
            throw new NcException("Variable is not (effectively) scalar.");
        }
        try {
            Array a1 = njvar.read();
            if (a1 == null) {
                LOGGER.trace("njvar read returns null");
                return null;
            }
            Array aa = a1.reduce();
            if (aa.getRank() > 0) {
                LOGGER.trace("- array has rank > 0");
            } else if (aa.getSize() != 1L) {
                LOGGER.trace("- array has size != 1");
            }
            return aa.getObject(0);
        }
        catch (Exception exc) {
            LOGGER.trace("Exception occurred extracting scalar value: {}", (Object)exc.toString());
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            return null;
        }
    }
}

