/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc;

import gov.nasa.giss.text.PrintfFormat;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NcUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static double objectValueToDouble(Object oo) {
        if (oo == null) {
            LOGGER.trace("Object is null");
            return Double.NaN;
        }
        if (oo instanceof Double || oo instanceof Float) {
            return (Double)oo;
        }
        if (oo instanceof Long || oo instanceof Integer || oo instanceof Short || oo instanceof Byte) {
            return (Double)oo;
        }
        if (oo instanceof Character) {
            Character cc = (Character)oo;
            char ii = cc.charValue();
            return ii;
        }
        LOGGER.trace("Not a numeric type we know how to deal with.");
        return Double.NaN;
    }

    public static void appendScalarObjectValue(StringBuilder sb, Object oo) {
        if (oo instanceof Double || oo instanceof Float) {
            sb.append(PrintfFormat.PFORMAT_7G.sprintfx(oo));
        } else if (oo instanceof Long || oo instanceof Integer || oo instanceof Short || oo instanceof Byte) {
            sb.append(oo.toString());
        } else if (oo instanceof Character) {
            Character cc = (Character)oo;
            sb.append((int)cc.charValue());
            if (Character.isAlphabetic(cc.charValue())) {
                sb.append(" = '").append(cc).append("'");
            }
        } else {
            sb.append("'").append(oo.toString()).append("'");
        }
    }

    private NcUtils() {
    }
}

