/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc;

import gov.nasa.giss.data.nc.NcAxis;
import gov.nasa.giss.data.nc.NcAxisType;
import gov.nasa.giss.data.nc.NcDataset;
import gov.nasa.giss.data.nc.NcVarUtils;
import gov.nasa.giss.time.AbsoluteTime;
import gov.nasa.giss.time.JulianTime;
import gov.nasa.giss.time.JulianType;
import gov.nasa.giss.time.TimeFormatter;
import gov.nasa.giss.time.UnixTimeFormatter;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Variable;

public class NcTimeAxis
extends NcAxis {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private TimeFormatter formatter_;
    private boolean isRelativeTime_;

    public NcTimeAxis(NcDataset ncd, Variable dimvar) {
        super(NcAxisType.TIME, ncd, dimvar);
        this.initMe();
    }

    private void initMe() {
        block16: {
            String unitsStr = this.getUnitsString();
            if (unitsStr == null) {
                LOGGER.trace("Units are null.");
                return;
            }
            if (unitsStr.contains(" since ")) {
                LOGGER.trace("Appears to be relative time.");
                try {
                    this.formatter_ = NcVarUtils.getRelativeTimeHandler(this.dataset_, this.njaxisvar_);
                    this.isRelativeTime_ = true;
                }
                catch (Exception exc) {
                    LOGGER.warn("Failed creating relative time handler: {}", (Object)exc.toString());
                    this.formatter_ = null;
                }
            } else {
                if ("Julian Date".equalsIgnoreCase(unitsStr) || "Julian Day".equalsIgnoreCase(unitsStr) || "True Julian Date".equalsIgnoreCase(unitsStr) || "True Julian Day".equalsIgnoreCase(unitsStr)) {
                    try {
                        this.formatter_ = new JulianTime();
                        this.isRelativeTime_ = true;
                    }
                    catch (Exception exc) {
                        this.formatter_ = null;
                        if (LOGGER.isTraceEnabled()) {
                            exc.printStackTrace();
                        }
                        break block16;
                    }
                }
                if ("Modified Julian Date".equalsIgnoreCase(unitsStr) || "Modified Julian Day".equalsIgnoreCase(unitsStr)) {
                    try {
                        this.formatter_ = new JulianTime(JulianType.MODIFIED);
                        this.isRelativeTime_ = true;
                    }
                    catch (Exception exc) {
                        this.formatter_ = null;
                        if (LOGGER.isTraceEnabled()) {
                            exc.printStackTrace();
                        }
                        break block16;
                    }
                }
                if (unitsStr.contains(" as ")) {
                    try {
                        this.formatter_ = new AbsoluteTime(NcVarUtils.getUnitsString(this.njaxisvar_));
                    }
                    catch (Exception exc) {
                        this.formatter_ = null;
                        if (!LOGGER.isTraceEnabled()) break block16;
                        exc.printStackTrace();
                    }
                }
            }
        }
    }

    @Override
    public boolean hasPositive() {
        return false;
    }

    @Override
    public boolean isPositiveUp() {
        return false;
    }

    @Override
    public boolean isPositiveDown() {
        return false;
    }

    @Override
    public boolean isPressure() {
        return false;
    }

    @Override
    public boolean isHeight() {
        return false;
    }

    @Override
    public boolean isDepth() {
        return false;
    }

    public boolean isUnixTime() {
        boolean isUT = this.isFormattedTime() && this.formatter_ instanceof UnixTimeFormatter;
        LOGGER.trace("{}, {}", (Object)this.getShortName(), (Object)isUT);
        return isUT;
    }

    public boolean isFormattedTime() {
        if (this.formatter_ == null) {
            LOGGER.trace("{}, formatter is null", (Object)this.getShortName());
        }
        return this.formatter_ != null;
    }

    public TimeFormatter getFormatter() {
        return this.formatter_;
    }

    @Override
    public String getUnitsString() {
        return super.getUnitsString();
    }

    public String formatValue(double value) {
        if (this.formatter_ == null) {
            return null;
        }
        return this.formatter_.format(value);
    }
}

