/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc;

import gov.nasa.giss.data.nc.NcDataNode;
import gov.nasa.giss.data.nc.NcStructure;
import gov.nasa.giss.data.nc.NcUtils;
import gov.nasa.giss.text.StringUtils;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.nc2.dataset.StructureDS;
import ucar.nc2.dataset.VariableDS;

public class NcStructureMember
extends NcDataNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final NcStructure ncstruct_ = (NcStructure)this.getNcParent();
    private final VariableDS njvarDS_;

    public NcStructureMember(NcStructure parent, VariableDS njvarDS) {
        super(parent);
        this.njvarDS_ = njvarDS;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public boolean getAllowsChildren() {
        return false;
    }

    @Override
    public Object getObject() {
        return this.njvarDS_;
    }

    @Override
    public String getName() {
        return this.getShortName();
    }

    @Override
    public String getNjPath() {
        return this.njvarDS_.getFullName();
    }

    @Override
    public String getLongName() {
        return this.ncstruct_.getName() + "." + this.getName();
    }

    @Override
    public String getShortName() {
        return this.njvarDS_.getShortName();
    }

    @Override
    public String getNcType() {
        return "\u2014";
    }

    @Override
    public String getDetail(boolean enhanced) {
        String fname = this.njvarDS_.getFullName();
        String mname = this.getLongName();
        StringBuilder sb = new StringBuilder(128);
        sb.append("<html>").append("<head>");
        this.appendDetailStyle(sb);
        sb.append("</head>").append("<body>").append("<h2>Structure member \"").append(mname).append("\"</h2>\n").append("<h3>In file \"").append(this.ncdataset_.getName()).append("\"</h3>\n");
        if (!mname.equals(fname)) {
            sb.append("<p>Member full name: ").append(fname).append("</p>");
        }
        sb.append("<hr>").append("<pre>").append(StringUtils.escapeHtmlSimplistic(this.njvarDS_.toString())).append("</pre>");
        this.appendScalarInfo(sb, enhanced);
        if (LOGGER.isDebugEnabled()) {
            this.appendDebugInfo(sb);
        }
        sb.append("</body></html>");
        return sb.toString();
    }

    private void appendScalarInfo(StringBuilder sb, boolean enhanced) {
        block7: {
            if (!this.isEffectivelyScalar()) {
                return;
            }
            LOGGER.trace("struct and var both look like scalars");
            try {
                Array aa = this.njvarDS_.read();
                Object oo = aa.getObject(0);
                if (oo == null) {
                    LOGGER.trace("getScalarValue returned null");
                    return;
                }
                sb.append("<hr>").append("<p>");
                if (this.njvarDS_.isScalar()) {
                    sb.append("Scalar variable has value: ");
                } else {
                    sb.append("Array is single-valued, with value: ");
                }
                NcUtils.appendScalarObjectValue(sb, oo);
                sb.append("</p>");
            }
            catch (Exception exc) {
                if (LOGGER.isDebugEnabled()) {
                    sb.append("<hr>").append("<p>").append("Exception occurred extracting structure member's scalar value: ").append(exc.toString()).append("</p>");
                }
                LOGGER.debug("Could not extract scalar value: {}", (Object)exc.toString());
                if (!LOGGER.isTraceEnabled()) break block7;
                exc.printStackTrace();
            }
        }
    }

    private void appendDebugInfo(StringBuilder sb) {
        StructureDS njstructDS = (StructureDS)this.ncstruct_.getObject();
        sb.append("<hr>").append("<p><b>Debug info:</b></p>\n").append("<pre>");
        sb.append("Member variable has reported size ").append(this.njvarDS_.getSize()).append('\n');
        try {
            Array aa = this.njvarDS_.read();
            long isize = aa.getSize();
            sb.append("Read array has reported size ").append(isize).append('\n');
        }
        catch (Exception exc) {
            sb.append("Exception reading array").append('\n');
        }
        sb.append("Parent structure has rank ").append(njstructDS.getRank()).append('\n');
        int[] shape = njstructDS.getShape();
        sb.append("Parent structure has shape ");
        if (shape == null || shape.length == 0) {
            sb.append("scalar");
        } else {
            for (int i = 0; i < shape.length; ++i) {
                sb.append("[").append(shape[i]).append("]");
            }
        }
        sb.append('\n');
        sb.append("Parent structure has size ").append(njstructDS.getSize()).append('\n');
        sb.append("</pre>");
    }

    @Override
    public String getDetailType() {
        return "text/html";
    }

    @Override
    public String toString() {
        return this.njvarDS_.getFullName();
    }

    private boolean isEffectivelyScalar() {
        if (this.njvarDS_.getSize() > 1L) {
            return false;
        }
        int[] shape = this.ncstruct_.getShape();
        return this.ncstruct_.getRank() == 0 || shape.length == 1 && shape[0] == 1;
    }
}

