/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc;

import com.google.common.collect.ImmutableList;
import gov.nasa.giss.data.nc.NcDataset;
import gov.nasa.giss.data.nc.NcDimensionVariable;
import gov.nasa.giss.data.nc.NcVarUtils;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Dimension;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.VariableDS;

public class NcDimension {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Dimension njdim_;
    private NcDimensionVariable dimvar_;
    private String longName_;
    private String units_;
    private final String[] values_;

    /*
     * WARNING - void declaration
     */
    public NcDimension(NcDataset ncd, VariableDS varDS, Dimension njdim) {
        String[] tokens;
        Objects.requireNonNull(ncd, "Dataset cannot be null.");
        Objects.requireNonNull(njdim, "NJ dimension cannot be null.");
        this.njdim_ = njdim;
        String dname = njdim.getShortName();
        VariableDS cv = null;
        ImmutableList<CoordinateSystem> csList = null;
        csList = varDS == null ? ncd.getNjDataset().getCoordinateSystems() : varDS.getCoordinateSystems();
        for (CoordinateSystem coordinateSystem : csList) {
            ImmutableList<CoordinateAxis> axesList = coordinateSystem.getCoordinateAxes();
            for (CoordinateAxis axis : axesList) {
                Dimension dx;
                if (!(axis instanceof CoordinateAxis1D) || (dx = axis.getDimension(0)) == null || !dx.equals(njdim) || !axis.getShortName().equalsIgnoreCase(dname)) continue;
                cv = axis;
                break;
            }
            if (cv == null) continue;
            break;
        }
        if (cv == null) {
            cv = ncd.getCoordinateVariable(njdim);
        }
        if (cv == null && (tokens = NcVarUtils.parseCoordinatesAttribute(varDS)) != null) {
            for (String token : tokens) {
                Dimension dx;
                int rank;
                VariableDS tokenVar = ncd.getVariableDS(token);
                if (tokenVar == null || (rank = tokenVar.getRank()) != 1 || (dx = tokenVar.getDimension(0)) == null || !dx.equals(njdim)) continue;
                cv = tokenVar;
                break;
            }
        }
        if (cv == null) {
            this.dimvar_ = null;
        } else {
            try {
                this.dimvar_ = new NcDimensionVariable(ncd, cv);
            }
            catch (Exception exc) {
                LOGGER.warn("Ouch! {}", (Object)exc.toString());
                LOGGER.warn("** Ignoring exception and setting dimvar null.");
                this.dimvar_ = null;
            }
        }
        int length = this.njdim_.getLength();
        this.values_ = new String[length];
        if (this.dimvar_ == null) {
            void var8_14;
            boolean bl = false;
            while (var8_14 < length) {
                this.values_[var8_14] = (int)(var8_14 + true) + " of " + length;
                ++var8_14;
            }
        }
    }

    public Dimension getNjDimension() {
        return this.njdim_;
    }

    public int getLength() {
        return this.values_.length;
    }

    public String getName() {
        return this.njdim_.getShortName();
    }

    public String getLongName() {
        if (this.longName_ == null) {
            String defaultName = this.njdim_.getShortName();
            StringBuilder sb = new StringBuilder("");
            if (this.dimvar_ == null) {
                sb.append(defaultName);
            } else {
                sb.append(this.dimvar_.getLongName());
            }
            if (sb.length() > 0) {
                sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
            }
            this.longName_ = sb.toString();
        }
        return this.longName_;
    }

    public String getUnitsString() {
        if (this.units_ == null) {
            this.units_ = this.dimvar_ == null ? "" : this.dimvar_.getUnitsString();
        }
        return this.units_;
    }

    public boolean hasBounds() {
        if (this.dimvar_ == null) {
            return false;
        }
        return this.dimvar_.hasBounds();
    }

    public boolean hasFormatting() {
        return this.dimvar_ != null;
    }

    public Object valueAt(int index) {
        if (this.dimvar_ == null) {
            return this.values_[index];
        }
        return this.dimvar_.valueAt(index);
    }

    public String formattedValueAt(int index) {
        if (this.dimvar_ == null) {
            return Integer.toString(index + 1);
        }
        return this.dimvar_.formattedValueAt(index);
    }

    public Object[] getValues() {
        if (this.dimvar_ == null) {
            return this.values_;
        }
        return this.dimvar_.getValues();
    }

    public String formattedBoundsAt(int index) {
        if (this.dimvar_ == null) {
            return null;
        }
        return this.dimvar_.formattedBoundsAt(index);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof NcDimension)) {
            return false;
        }
        NcDimension dim2 = (NcDimension)o;
        return this.njdim_.equals(dim2.getNjDimension());
    }

    public int hashCode() {
        return this.njdim_.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("NcDimension(");
        sb.append("name=").append(this.getName()).append(',').append("units=").append(this.getUnitsString()).append(',').append("values=[").append(this.formattedValueAt(0)).append(",...").append("])");
        return sb.toString();
    }
}

