/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.data.nc;

import gov.nasa.giss.data.nc.NcVarTypeDetector;
import gov.nasa.giss.io.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Date;
import java.util.Objects;
import org.apache.http.client.CredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.httpservices.HTTPSession;
import ucar.nc2.dods.DODSNetcdfFile;
import ucar.nc2.grib.GribIndexCache;
import ucar.nc2.grib.grib1.tables.Grib1ParamTables;
import ucar.nc2.util.DiskCache;
import ucar.nc2.util.DiskCache2;
import ucar.nc2.util.xml.RuntimeConfigParser;

public final class NcConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static File cacheDir_;
    private static boolean nj22configRead_;

    public static void setDevoMode() {
        LOGGER.debug("Setting NC devo mode");
        NcVarTypeDetector.setDevoMode();
    }

    public static void disableRemotePreload() {
        DODSNetcdfFile.setPreload(false);
    }

    public static void initHttpClient(String agent, CredentialsProvider cprov) {
        block3: {
            HTTPSession.setGlobalUserAgent(agent);
            if (cprov == null) {
                return;
            }
            try {
                HTTPSession.setGlobalCredentialsProvider(cprov);
            }
            catch (Exception exc) {
                LOGGER.error("Unable to set credentials provider: {}", (Object)exc.toString());
                if (!LOGGER.isTraceEnabled()) break block3;
                exc.printStackTrace();
            }
        }
    }

    public static void initCache(String appname, String domain) {
        if (cacheDir_ != null) {
            return;
        }
        String qAppname = (domain + "." + appname).toLowerCase();
        cacheDir_ = FileUtils.getAppCacheDirectory(appname, qAppname);
        if (cacheDir_ == null) {
            LOGGER.warn("Got null creating cache directory object {}", (Object)cacheDir_);
            return;
        }
        String cpath = cacheDir_.getAbsolutePath();
        try {
            if (!cacheDir_.exists()) {
                cacheDir_.mkdirs();
            }
        }
        catch (Exception exc) {
            LOGGER.warn("Cache dir {} does not exist and cannot be created.", (Object)cpath);
            LOGGER.warn("Exception reported was: {}", (Object)exc.toString());
            LOGGER.warn("This may block opening GRIB files and cause other problems.");
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            return;
        }
        DiskCache.setRootDirectory(cpath);
        DiskCache.setCachePolicy(true);
        DiskCache2 dc2 = new DiskCache2(cpath, false, 60, 50);
        dc2.setAlwaysUseCache(true);
        GribIndexCache.setDiskCache2(dc2);
    }

    public static void clearCache() {
        block2: {
            DiskCache.cleanCache(new Date(), new StringBuilder());
            try {
                FileUtils.deleteDirectoryContents(cacheDir_);
            }
            catch (Exception exc) {
                LOGGER.warn("Error clearing cache directory {}", (Object)cacheDir_);
                if (!LOGGER.isTraceEnabled()) break block2;
                exc.printStackTrace();
            }
        }
    }

    public static void initGribHandling(boolean strict) {
        block5: {
            NcConfig.setGrib1Strict(strict);
            File gissSupportDir = FileUtils.getGISSAppSupportDirectory();
            File tabdir = new File(gissSupportDir, "gribtab");
            if (!tabdir.exists()) {
                LOGGER.debug("Apparent GRIBTAB directory does not exist.");
                return;
            }
            if (!tabdir.isDirectory()) {
                LOGGER.debug("Apparent GRIBTAB path exists but is not a directory.");
                return;
            }
            try {
                File f = new File(tabdir, "grib1lookuptable.lst");
                if (f.exists()) {
                    NcConfig.openGrib1LookupList(f);
                }
            }
            catch (Exception exc) {
                LOGGER.warn("Error creating GRIB-1 lookup list File object {}", exc);
                if (!LOGGER.isTraceEnabled()) break block5;
                exc.printStackTrace();
            }
        }
    }

    public static void setGrib1Strict(boolean strict) {
        Grib1ParamTables.setStrict(strict);
    }

    private static boolean openGrib1LookupList(File f) {
        Objects.requireNonNull(f, "Null File passed");
        if (!f.exists()) {
            throw new IllegalArgumentException("No file matching File object");
        }
        try {
            Grib1ParamTables.addParameterTableLookup(f.getAbsolutePath());
            return true;
        }
        catch (Exception exc) {
            LOGGER.warn("Exception accessing GRIB-1 lookup list {}", exc);
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            return false;
        }
    }

    public static boolean openGrib1Table(File f, int center, int subcenter, int version) {
        Objects.requireNonNull(f, "Null File passed");
        if (!f.exists()) {
            throw new IllegalArgumentException("No file matching File object");
        }
        try {
            Grib1ParamTables.addParameterTable(center, subcenter, version, f.getAbsolutePath());
            return true;
        }
        catch (Exception exc) {
            LOGGER.warn("Exception accessing GRIB-1 lookup table {}", exc);
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            return false;
        }
    }

    public static void readNj22Config() {
        if (!nj22configRead_) {
            String homeDir;
            block18: {
                homeDir = null;
                try {
                    homeDir = System.getProperty("user.home");
                }
                catch (Exception exc) {
                    LOGGER.warn("Exception getting user.home property: {}", (Object)exc.toString());
                    if (!LOGGER.isTraceEnabled()) break block18;
                    exc.printStackTrace();
                }
            }
            if (homeDir == null) {
                LOGGER.debug("homeDir is null.");
                nj22configRead_ = true;
                return;
            }
            File udir = new File(homeDir, ".unidata");
            File f = new File(udir, "nj22Config.xml");
            LOGGER.trace("nj22Config.xml exists? {}", (Object)f.exists());
            if (f.exists()) {
                StringBuilder sb = new StringBuilder();
                try (FileInputStream fis = new FileInputStream(f);){
                    RuntimeConfigParser.read(fis, sb);
                }
                catch (IOException ioe) {
                    LOGGER.warn("Error reading nj22Config, {}", (Object)ioe.getMessage());
                    LOGGER.debug("errorLog = {}", (Object)sb.toString());
                }
            }
            nj22configRead_ = true;
        }
    }

    private NcConfig() {
    }
}

