/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.write;

import com.google.common.collect.Sets;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.output.Format;
import org.jdom2.output.LineSeparator;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.EnumTypedef;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.util.Misc;
import ucar.nc2.util.URLnaming;
import ucar.nc2.util.xml.Parse;

public class NcmlWriter {
    private static final Logger log = LoggerFactory.getLogger(NcmlWriter.class);
    private static final Namespace ncmlDefaultNamespace = Namespace.getNamespace("http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2");
    public static final Predicate<? super Variable> writeNoVariablesPredicate = attributes -> false;
    public static final Predicate<? super Variable> writeMetadataVariablesPredicate = Variable::isMetadata;
    public static final Predicate<? super Variable> writeCoordinateVariablesPredicate = Variable::isCoordinateVariable;
    public static final Predicate<? super Variable> writeAllVariablesPredicate = v -> true;
    private final Namespace namespace;
    private final Format xmlFormat;
    private final Predicate<? super Variable> writeValuesPredicate;
    private final XMLOutputter xmlOutputter = new XMLOutputter();

    public NcmlWriter(@Nullable Namespace namespace, @Nullable Format xmlFormat, @Nullable Predicate<? super Variable> writeValuesPredicate) {
        this.namespace = namespace == null ? ncmlDefaultNamespace : namespace;
        this.xmlFormat = xmlFormat == null ? Format.getPrettyFormat().setLineSeparator(LineSeparator.UNIX) : xmlFormat;
        this.writeValuesPredicate = writeValuesPredicate == null ? writeMetadataVariablesPredicate : writeValuesPredicate;
    }

    public NcmlWriter() {
        this.namespace = ncmlDefaultNamespace;
        this.xmlFormat = Format.getPrettyFormat().setLineSeparator(LineSeparator.UNIX);
        this.writeValuesPredicate = writeMetadataVariablesPredicate;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public Format getXmlFormat() {
        return this.xmlFormat;
    }

    public Predicate<? super Variable> getWriteValuesPredicate() {
        return this.writeValuesPredicate;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String writeToString(Element elem) {
        try (StringWriter writer = new StringWriter();){
            this.writeToWriter(elem, writer);
            String string = writer.toString();
            return string;
        }
        catch (IOException e) {
            throw new AssertionError("CAN'T HAPPEN: StringWriter.close() is a no-op.", e);
        }
    }

    public void writeToFile(Element elem, File outFile) throws IOException {
        try (BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(outFile, false));){
            this.writeToStream(elem, outStream);
        }
    }

    public void writeToStream(Element elem, OutputStream outStream) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(outStream), this.xmlFormat.getEncoding()));){
            this.writeToWriter(elem, writer);
        }
    }

    public void writeToWriter(Element elem, Writer writer) throws IOException {
        this.xmlOutputter.setFormat(this.xmlFormat);
        elem.detach();
        this.xmlOutputter.output(new Document(elem), writer);
    }

    public Element makeExplicitNetcdfElement(NetcdfFile ncFile, @Nullable String location) {
        Element netcdfElem = this.makeNetcdfElement(ncFile, location);
        netcdfElem.addContent(0, new Element("explicit", this.namespace));
        return netcdfElem;
    }

    public Element makeNetcdfElement(NetcdfFile ncFile, @Nullable String location) {
        Element rootElem = this.makeGroupElement(ncFile.getRootGroup());
        rootElem.setName("netcdf");
        rootElem.removeAttribute("name");
        rootElem.addNamespaceDeclaration(this.namespace);
        if (null == location) {
            location = ncFile.getLocation();
        }
        if (null != location) {
            rootElem.setAttribute("location", URLnaming.canonicalizeWrite(location));
        }
        if (null != ncFile.getId()) {
            rootElem.setAttribute("id", ncFile.getId());
        }
        if (null != ncFile.getTitle()) {
            rootElem.setAttribute("title", ncFile.getTitle());
        }
        return rootElem;
    }

    public Element makeGroupElement(Group group) {
        Element elem = new Element("group", this.namespace);
        elem.setAttribute("name", group.getShortName());
        for (EnumTypedef etd : group.getEnumTypedefs()) {
            elem.addContent(this.makeEnumTypedefElement(etd));
        }
        for (Dimension dim : group.getDimensions()) {
            elem.addContent(this.makeDimensionElement(dim));
        }
        for (Variable var : group.getVariables()) {
            boolean showValues = this.writeValuesPredicate.test(var);
            elem.addContent(this.makeVariableElement(var, showValues));
        }
        for (Group g2 : group.getGroups()) {
            Element groupElem = new Element("group", this.namespace);
            groupElem.setAttribute("name", g2.getShortName());
            elem.addContent(this.makeGroupElement(g2));
        }
        for (Attribute att : group.attributes()) {
            elem.addContent(this.makeAttributeElement(att));
        }
        return elem;
    }

    public Element makeEnumTypedefElement(EnumTypedef etd) {
        Element typeElem = new Element("enumTypedef", this.namespace);
        typeElem.setAttribute("name", etd.getShortName());
        typeElem.setAttribute("type", etd.getBaseType().toString());
        TreeMap<Integer, String> map = new TreeMap<Integer, String>(etd.getMap());
        for (Map.Entry<Integer, String> entry : map.entrySet()) {
            typeElem.addContent(new Element("enum", this.namespace).setAttribute("key", Integer.toString(entry.getKey())).addContent(entry.getValue()));
        }
        return typeElem;
    }

    public Element makeDimensionElement(Dimension dim) throws IllegalArgumentException {
        if (!dim.isShared()) {
            throw new IllegalArgumentException("Cannot create private dimension: in NcML, <dimension> elements are always shared.");
        }
        Element dimElem = new Element("dimension", this.namespace);
        dimElem.setAttribute("name", dim.getShortName());
        dimElem.setAttribute("length", Integer.toString(dim.getLength()));
        if (dim.isUnlimited()) {
            dimElem.setAttribute("isUnlimited", "true");
        }
        return dimElem;
    }

    public Element makeVariableElement(Variable var, boolean showValues) {
        Element varElem;
        block11: {
            block10: {
                boolean isStructure = var instanceof Structure;
                varElem = new Element("variable", this.namespace);
                varElem.setAttribute("name", var.getShortName());
                StringBuilder buff = new StringBuilder();
                List dims = var.getDimensions();
                for (int i = 0; i < dims.size(); ++i) {
                    Dimension dim = (Dimension)dims.get(i);
                    if (i > 0) {
                        buff.append(" ");
                    }
                    if (dim.isShared()) {
                        buff.append(dim.getShortName());
                        continue;
                    }
                    if (dim.isVariableLength()) {
                        buff.append("*");
                        continue;
                    }
                    buff.append(dim.getLength());
                }
                varElem.setAttribute("shape", buff.toString());
                DataType dt = var.getDataType();
                if (dt != null) {
                    varElem.setAttribute("type", dt.toString());
                    if (dt.isEnum()) {
                        varElem.setAttribute("typedef", var.getEnumTypedef().getShortName());
                    }
                }
                for (Object att : var.attributes()) {
                    varElem.addContent(this.makeAttributeElement((Attribute)att));
                }
                if (!isStructure) break block10;
                Structure s2 = (Structure)var;
                for (Variable variable : s2.getVariables()) {
                    varElem.addContent(this.makeVariableElement(variable, showValues));
                }
                break block11;
            }
            if (!showValues) break block11;
            try {
                varElem.addContent(this.makeValuesElement(var, true));
            }
            catch (IOException e) {
                String message = String.format("Couldn't read values for %s. Omitting <values> element.%n\t%s", var.getFullName(), e.getMessage());
                log.warn(message);
            }
        }
        return varElem;
    }

    public Element makeAttributeElement(Attribute attribute) {
        Element attElem = new Element("attribute", this.namespace);
        attElem.setAttribute("name", attribute.getShortName());
        DataType dt = attribute.getDataType();
        if (dt != null && dt != DataType.STRING) {
            attElem.setAttribute("type", dt.toString());
        }
        if (attribute.getLength() == 0) {
            return attElem;
        }
        if (attribute.isString()) {
            StringBuilder buff = new StringBuilder();
            for (int i = 0; i < attribute.getLength(); ++i) {
                String sval = attribute.getStringValue(i);
                if (i > 0) {
                    buff.append("|");
                }
                buff.append(sval);
            }
            attElem.setAttribute("value", Parse.cleanCharacterData(buff.toString()));
            if (attribute.getLength() > 1) {
                attElem.setAttribute("separator", "|");
            }
        } else {
            StringBuilder buff = new StringBuilder();
            for (int i = 0; i < attribute.getLength(); ++i) {
                Number val = attribute.getNumericValue(i);
                if (i > 0) {
                    buff.append(" ");
                }
                buff.append(val);
            }
            attElem.setAttribute("value", buff.toString());
        }
        return attElem;
    }

    public Element makeValuesElement(Variable variable, boolean allowRegular) throws IOException {
        Element elem = new Element("values", this.namespace);
        StringBuilder buff = new StringBuilder();
        Array a = variable.read();
        if (variable.getDataType() == DataType.CHAR) {
            char[] data = (char[])a.getStorage();
            elem.setText(new String(data));
        } else if (variable.getDataType() == DataType.STRING) {
            elem.setAttribute("separator", "|");
            int count = 0;
            IndexIterator iter = a.getIndexIterator();
            while (iter.hasNext()) {
                if (count++ > 0) {
                    buff.append("|");
                }
                buff.append(iter.getObjectNext());
            }
            elem.setText(buff.toString());
        } else {
            if (allowRegular && a.getRank() == 1 && a.getSize() > 2L) {
                Index ima = a.getIndex();
                double start = a.getDouble(ima.set(0));
                double incr = a.getDouble(ima.set(1)) - start;
                boolean isRegular = true;
                int i = 2;
                while ((long)i < a.getSize()) {
                    double v0;
                    double v1 = a.getDouble(ima.set(i));
                    if (!Misc.nearlyEquals(v1 - (v0 = a.getDouble(ima.set(i - 1))), incr)) {
                        isRegular = false;
                    }
                    ++i;
                }
                if (isRegular) {
                    elem.setAttribute("start", Double.toString(start));
                    elem.setAttribute("increment", Double.toString(incr));
                    elem.setAttribute("npts", Long.toString(variable.getSize()));
                    return elem;
                }
            }
            boolean isRealType = variable.getDataType() == DataType.DOUBLE || variable.getDataType() == DataType.FLOAT;
            IndexIterator iter = a.getIndexIterator();
            buff.append(isRealType ? iter.getDoubleNext() : (double)iter.getIntNext());
            while (iter.hasNext()) {
                buff.append(" ");
                buff.append(isRealType ? iter.getDoubleNext() : (double)iter.getIntNext());
            }
            elem.setText(buff.toString());
        }
        return elem;
    }

    public static class WriteVariablesWithNamesPredicate
    implements Predicate<Variable> {
        private final Set<String> variableNames;

        public WriteVariablesWithNamesPredicate(Iterable<String> variableNames) {
            this.variableNames = Sets.newHashSet(variableNames);
        }

        @Override
        public boolean test(Variable var) {
            return this.variableNames.contains(var.getFullName());
        }
    }
}

